"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readEmbeddedBlockMapData = exports.BLOCK_MAP_FILE_NAME = void 0;

function _bluebirdLst() {
  const data = _interopRequireWildcard(require("bluebird-lst"));

  _bluebirdLst = function () {
    return data;
  };

  return data;
}

function _fsExtraP() {
  const data = require("fs-extra-p");

  _fsExtraP = function () {
    return data;
  };

  return data;
}

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

const BLOCK_MAP_FILE_NAME = "_blockMap.blockmap";
exports.BLOCK_MAP_FILE_NAME = BLOCK_MAP_FILE_NAME;

let readEmbeddedBlockMapData = (() => {
  var _ref = (0, _bluebirdLst().coroutine)(function* (file) {
    const fd = yield (0, _fsExtraP().open)(file, "r");

    try {
      const fileSize = (yield (0, _fsExtraP().fstat)(fd)).size;
      const sizeBuffer = Buffer.allocUnsafe(4);
      yield (0, _fsExtraP().read)(fd, sizeBuffer, 0, sizeBuffer.length, fileSize - sizeBuffer.length);
      const dataBuffer = Buffer.allocUnsafe(sizeBuffer.readUInt32BE(0));
      yield (0, _fsExtraP().read)(fd, dataBuffer, 0, dataBuffer.length, fileSize - sizeBuffer.length - dataBuffer.length);
      yield (0, _fsExtraP().close)(fd);

      const inflateRaw = _bluebirdLst().default.promisify(require("zlib").inflateRaw);

      return (yield inflateRaw(dataBuffer)).toString();
    } catch (e) {
      yield (0, _fsExtraP().close)(fd);
      throw e;
    }
  });

  return function readEmbeddedBlockMapData(_x) {
    return _ref.apply(this, arguments);
  };
})(); exports.readEmbeddedBlockMapData = readEmbeddedBlockMapData;
//# sourceMappingURL=blockMapApi.js.map