/// <reference types="node" />
export declare class UUID {
    private ascii;
    private binary;
    private readonly version;
    static readonly URL: UUID;
    static readonly OID: Buffer;
    constructor(uuid: Buffer | string);
    static v1(): any;
    static v5(name: string | Buffer, namespace: Buffer): any;
    toString(): string;
    toBuffer(): Buffer;
    inspect(): string;
    static check(uuid: Buffer | string, offset?: number): false | {
        version: undefined;
        variant: string;
        format: string;
    } | {
        version: number;
        variant: string;
        format: string;
    };
    static parse(input: string): Buffer;
}
export interface UuidOptions {
    encoding?: string;
    name?: string;
    namespace?: string | UUID | Buffer;
}
export declare const nil: UUID;
