"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.download = download;
exports.getBinFromGithub = getBinFromGithub;
exports.getBin = getBin;

function _util() {
  const data = require("./util");

  _util = function () {
    return data;
  };

  return data;
}

const versionToPromise = new Map();

function download(url, output, checksum) {
  const args = ["download", "--url", url, "--output", output];

  if (checksum != null) {
    args.push("--sha512", checksum);
  }

  return (0, _util().executeAppBuilder)(args);
}

function getBinFromGithub(name, version, checksum) {
  const dirName = `${name}-${version}`;
  return getBin(dirName, `https://github.com/electron-userland/electron-builder-binaries/releases/download/${dirName}/${dirName}.7z`, checksum);
}

function getBin(name, url, checksum) {
  let promise = versionToPromise.get(name); // if rejected, we will try to download again

  if (promise != null) {
    return promise;
  }

  promise = doGetBin(name, url, checksum);
  versionToPromise.set(name, promise);
  return promise;
}

function doGetBin(name, url, checksum) {
  const args = ["download-artifact", "--url", url, "--name", name];

  if (checksum != null) {
    args.push("--sha512", checksum);
  }

  return (0, _util().executeAppBuilder)(args);
} 
//# sourceMappingURL=binDownload.js.map