"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMacOsVersion = getMacOsVersion;
exports.isCanSignDmg = exports.isMacOsHighSierra = exports.isMacOsSierra = void 0;

function _bluebirdLst() {
  const data = require("bluebird-lst");

  _bluebirdLst = function () {
    return data;
  };

  return data;
}

function _fsExtraP() {
  const data = require("fs-extra-p");

  _fsExtraP = function () {
    return data;
  };

  return data;
}

function _lazyVal() {
  const data = require("lazy-val");

  _lazyVal = function () {
    return data;
  };

  return data;
}

function semver() {
  const data = _interopRequireWildcard(require("semver"));

  semver = function () {
    return data;
  };

  return data;
}

function _util() {
  const data = require("./util");

  _util = function () {
    return data;
  };

  return data;
}

let isOsVersionGreaterThanOrEqualTo = (() => {
  var _ref2 = (0, _bluebirdLst().coroutine)(function* (input) {
    return semver().gte((yield macOsVersion.value), clean(input));
  });

  return function isOsVersionGreaterThanOrEqualTo(_x) {
    return _ref2.apply(this, arguments);
  };
})();

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

const macOsVersion = new (_lazyVal().Lazy)((0, _bluebirdLst().coroutine)(function* () {
  const file = yield (0, _fsExtraP().readFile)("/System/Library/CoreServices/SystemVersion.plist", "utf8");
  const matches = /<key>ProductVersion<\/key>[\s\S]*<string>([\d.]+)<\/string>/.exec(file);

  if (!matches) {
    throw new Error("Couldn't find the macOS version");
  }

  _util().log.debug({
    version: matches[1]
  }, "macOS version");

  return clean(matches[1]);
}));

function clean(version) {
  return version.split(".").length === 2 ? `${version}.0` : version;
}

function getMacOsVersion() {
  return macOsVersion.value;
}

let isMacOsSierra = (() => {
  var _ref3 = (0, _bluebirdLst().coroutine)(function* () {
    return process.platform === "darwin" && (yield isOsVersionGreaterThanOrEqualTo("10.12.0"));
  });

  return function isMacOsSierra() {
    return _ref3.apply(this, arguments);
  };
})();

exports.isMacOsSierra = isMacOsSierra;

let isMacOsHighSierra = (() => {
  var _ref4 = (0, _bluebirdLst().coroutine)(function* () {
    return process.platform === "darwin" && (yield isOsVersionGreaterThanOrEqualTo("10.13.0"));
  });

  return function isMacOsHighSierra() {
    return _ref4.apply(this, arguments);
  };
})();

exports.isMacOsHighSierra = isMacOsHighSierra;

let isCanSignDmg = (() => {
  var _ref5 = (0, _bluebirdLst().coroutine)(function* () {
    return process.platform === "darwin" && (yield isOsVersionGreaterThanOrEqualTo("10.11.5"));
  });

  return function isCanSignDmg() {
    return _ref5.apply(this, arguments);
  };
})(); exports.isCanSignDmg = isCanSignDmg;
//# sourceMappingURL=macosVersion.js.map