"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializeToYaml = serializeToYaml;
exports.removePassword = removePassword;
exports.exec = exec;
exports.doSpawn = doSpawn;
exports.spawnAndWrite = spawnAndWrite;
exports.spawn = spawn;
exports.use = use;
exports.debug7zArgs = debug7zArgs;
exports.isEmptyOrSpaces = isEmptyOrSpaces;
exports.isTokenCharValid = isTokenCharValid;
exports.smarten = smarten;
exports.addValue = addValue;
exports.replaceDefault = replaceDefault;
exports.getPlatformIconFileName = getPlatformIconFileName;
exports.isPullRequest = isPullRequest;
exports.isEnvTrue = isEnvTrue;
exports.executeAppBuilder = executeAppBuilder;
Object.defineProperty(exports, "safeStringifyJson", {
  enumerable: true,
  get: function () {
    return _builderUtilRuntime().safeStringifyJson;
  }
});
Object.defineProperty(exports, "asArray", {
  enumerable: true,
  get: function () {
    return _builderUtilRuntime().asArray;
  }
});
Object.defineProperty(exports, "log", {
  enumerable: true,
  get: function () {
    return _log().log;
  }
});
Object.defineProperty(exports, "debug", {
  enumerable: true,
  get: function () {
    return _log().debug;
  }
});
Object.defineProperty(exports, "TmpDir", {
  enumerable: true,
  get: function () {
    return _tempFile().TmpDir;
  }
});
Object.defineProperty(exports, "isMacOsSierra", {
  enumerable: true,
  get: function () {
    return _macosVersion().isMacOsSierra;
  }
});
Object.defineProperty(exports, "isCanSignDmg", {
  enumerable: true,
  get: function () {
    return _macosVersion().isCanSignDmg;
  }
});
Object.defineProperty(exports, "execWine", {
  enumerable: true,
  get: function () {
    return _wine().execWine;
  }
});
Object.defineProperty(exports, "prepareWindowsExecutableArgs", {
  enumerable: true,
  get: function () {
    return _wine().prepareWindowsExecutableArgs;
  }
});
Object.defineProperty(exports, "Arch", {
  enumerable: true,
  get: function () {
    return _arch().Arch;
  }
});
Object.defineProperty(exports, "getArchCliNames", {
  enumerable: true,
  get: function () {
    return _arch().getArchCliNames;
  }
});
Object.defineProperty(exports, "toLinuxArchString", {
  enumerable: true,
  get: function () {
    return _arch().toLinuxArchString;
  }
});
Object.defineProperty(exports, "getArchSuffix", {
  enumerable: true,
  get: function () {
    return _arch().getArchSuffix;
  }
});
Object.defineProperty(exports, "archFromString", {
  enumerable: true,
  get: function () {
    return _arch().archFromString;
  }
});
Object.defineProperty(exports, "AsyncTaskManager", {
  enumerable: true,
  get: function () {
    return _asyncTaskManager().AsyncTaskManager;
  }
});
Object.defineProperty(exports, "DebugLogger", {
  enumerable: true,
  get: function () {
    return _DebugLogger().DebugLogger;
  }
});
Object.defineProperty(exports, "hashFile", {
  enumerable: true,
  get: function () {
    return _hash().hashFile;
  }
});
Object.defineProperty(exports, "copyFile", {
  enumerable: true,
  get: function () {
    return _fs().copyFile;
  }
});
Object.defineProperty(exports, "deepAssign", {
  enumerable: true,
  get: function () {
    return _deepAssign().deepAssign;
  }
});
exports.InvalidConfigurationError = exports.debug7z = void 0;

function _zipBin() {
  const data = require("7zip-bin");

  _zipBin = function () {
    return data;
  };

  return data;
}

function _appBuilderBin() {
  const data = require("app-builder-bin");

  _appBuilderBin = function () {
    return data;
  };

  return data;
}

function _builderUtilRuntime() {
  const data = require("builder-util-runtime");

  _builderUtilRuntime = function () {
    return data;
  };

  return data;
}

function _chalk() {
  const data = _interopRequireDefault(require("chalk"));

  _chalk = function () {
    return data;
  };

  return data;
}

function _child_process() {
  const data = require("child_process");

  _child_process = function () {
    return data;
  };

  return data;
}

function _crypto() {
  const data = require("crypto");

  _crypto = function () {
    return data;
  };

  return data;
}

var _debug2 = _interopRequireDefault(require("debug"));

function _jsYaml() {
  const data = require("js-yaml");

  _jsYaml = function () {
    return data;
  };

  return data;
}

var path = _interopRequireWildcard(require("path"));

require("source-map-support/register");

function _log() {
  const data = require("./log");

  _log = function () {
    return data;
  };

  return data;
}

function _tempFile() {
  const data = require("temp-file");

  _tempFile = function () {
    return data;
  };

  return data;
}

function _macosVersion() {
  const data = require("./macosVersion");

  _macosVersion = function () {
    return data;
  };

  return data;
}

function _wine() {
  const data = require("./wine");

  _wine = function () {
    return data;
  };

  return data;
}

function _arch() {
  const data = require("./arch");

  _arch = function () {
    return data;
  };

  return data;
}

function _asyncTaskManager() {
  const data = require("./asyncTaskManager");

  _asyncTaskManager = function () {
    return data;
  };

  return data;
}

function _DebugLogger() {
  const data = require("./DebugLogger");

  _DebugLogger = function () {
    return data;
  };

  return data;
}

function _hash() {
  const data = require("./hash");

  _hash = function () {
    return data;
  };

  return data;
}

function _fs() {
  const data = require("./fs");

  _fs = function () {
    return data;
  };

  return data;
}

function _deepAssign() {
  const data = require("./deepAssign");

  _deepAssign = function () {
    return data;
  };

  return data;
}

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const debug7z = (0, _debug2.default)("electron-builder:7z");
exports.debug7z = debug7z;

function serializeToYaml(object, skipInvalid = false) {
  return (0, _jsYaml().safeDump)(object, {
    lineWidth: 8000,
    skipInvalid
  });
}

function removePassword(input) {
  return input.replace(/(-String |-P |pass:| \/p |-pass )([^ ]+)/g, (match, p1, p2) => {
    if (p1.trim() === "/p" && p2.startsWith("\\\\Mac\\Host\\\\")) {
      // appx /p
      return `${p1}${p2}`;
    }

    return `${p1}${(0, _crypto().createHash)("sha256").update(p2).digest("hex")} (sha256 hash)`;
  });
}

function getProcessEnv(env) {
  if (process.platform === "win32") {
    return env;
  }

  const finalEnv = Object.assign({}, env || process.env); // without LC_CTYPE dpkg can returns encoded unicode symbols
  // set LC_CTYPE to avoid crash https://github.com/electron-userland/electron-builder/issues/503 Even "en_DE.UTF-8" leads to error.

  const locale = process.platform === "linux" ? process.env.LANG || "C.UTF-8" : "en_US.UTF-8";
  finalEnv.LANG = locale;
  finalEnv.LC_CTYPE = locale;
  finalEnv.LC_ALL = locale;
  return finalEnv;
}

function exec(file, args, options, isLogOutIfDebug = true) {
  if (_log().log.isDebugEnabled) {
    const logFields = {
      file,
      args: args == null ? "" : removePassword(args.join(" "))
    };

    if (options != null) {
      if (options.cwd != null) {
        logFields.cwd = options.cwd;
      }

      if (options.env != null) {
        const diffEnv = Object.assign({}, options.env);

        for (const name of Object.keys(process.env)) {
          if (process.env[name] === options.env[name]) {
            delete diffEnv[name];
          }
        }

        logFields.env = (0, _builderUtilRuntime().safeStringifyJson)(diffEnv);
      }
    }

    _log().log.debug(logFields, "executing");
  }

  return new Promise((resolve, reject) => {
    (0, _child_process().execFile)(file, args, Object.assign({}, options, {
      maxBuffer: 10 * 1024 * 1024,
      env: getProcessEnv(options == null ? null : options.env)
    }), (error, stdout, stderr) => {
      if (error == null) {
        if (isLogOutIfDebug && _log().log.isDebugEnabled) {
          const logFields = {
            file
          };

          if (stdout.length > 0) {
            logFields.stdout = stdout;
          }

          if (stderr.length > 0) {
            logFields.stderr = file.endsWith("wine") ? removeWineSpam(stderr.toString()) : stderr;
          }

          _log().log.debug(logFields, "executed");
        }

        resolve(stdout.toString());
      } else {
        let message = _chalk().default.red(removePassword(`Exit code: ${error.code}. ${error.message}`));

        if (stdout.length !== 0) {
          if (file.endsWith("wine")) {
            stdout = removeWineSpam(stdout.toString());
          }

          message += `\n${_chalk().default.yellow(stdout.toString())}`;
        }

        if (stderr.length !== 0) {
          if (file.endsWith("wine")) {
            stderr = removeWineSpam(stderr.toString());
          }

          message += `\n${_chalk().default.red(stderr.toString())}`;
        }

        reject(new Error(message));
      }
    });
  });
}

function removeWineSpam(out) {
  return out.toString().split("\n").filter(it => !it.includes("wine: cannot find L\"C:\\\\windows\\\\system32\\\\winemenubuilder.exe\"") && !it.includes("err:wineboot:ProcessRunKeys Error running cmd L\"C:\\\\windows\\\\system32\\\\winemenubuilder.exe")).join("\n");
}

function logSpawn(command, args, options) {
  // use general debug.enabled to log spawn, because it doesn't produce a lot of output (the only line), but important in any case
  if (!_log().log.isDebugEnabled) {
    return;
  }

  const argsString = args.join(" ");
  const logFields = {
    command: command + " " + (command === "docker" ? argsString : removePassword(argsString))
  };

  if (options != null && options.cwd != null) {
    logFields.cwd = options.cwd;
  }

  _log().log.debug(logFields, "spawning");
}

function doSpawn(command, args, options, extraOptions) {
  if (options == null) {
    options = {};
  }

  options.env = getProcessEnv(options.env);

  if (options.stdio == null) {
    const isDebugEnabled = _log().debug.enabled; // do not ignore stdout/stderr if not debug, because in this case we will read into buffer and print on error


    options.stdio = [extraOptions != null && extraOptions.isPipeInput ? "pipe" : "ignore", isDebugEnabled ? "inherit" : "pipe", isDebugEnabled ? "inherit" : "pipe"];
  }

  logSpawn(command, args, options);

  try {
    return (0, _child_process().spawn)(command, args, options);
  } catch (e) {
    throw new Error(`Cannot spawn ${command}: ${e.stack || e}`);
  }
}

function spawnAndWrite(command, args, data, options) {
  const childProcess = doSpawn(command, args, options, {
    isPipeInput: true
  });
  const timeout = setTimeout(() => childProcess.kill(), 4 * 60 * 1000);
  return new Promise((resolve, reject) => {
    handleProcess("close", childProcess, command, true, () => {
      try {
        clearTimeout(timeout);
      } finally {
        resolve();
      }
    }, error => {
      try {
        clearTimeout(timeout);
      } finally {
        reject(error.stack || error.toString());
      }
    });
    childProcess.stdin.end(data);
  });
}

function spawn(command, args, options, extraOptions) {
  return new Promise((resolve, reject) => {
    const isCollectOutput = options != null && (options.stdio === "pipe" || Array.isArray(options.stdio) && options.stdio.length === 3 && options.stdio[1] === "pipe");
    handleProcess("close", doSpawn(command, args || [], options, extraOptions), command, isCollectOutput, resolve, reject);
  });
}

function handleProcess(event, childProcess, command, isCollectOutput, resolve, reject) {
  childProcess.on("error", reject);
  let out = "";

  if (isCollectOutput && childProcess.stdout != null) {
    childProcess.stdout.on("data", data => {
      out += data;
    });
  }

  let errorOut = "";

  if (childProcess.stderr != null) {
    childProcess.stderr.on("data", data => {
      errorOut += data;
    });
  }

  childProcess.once(event, code => {
    if (_log().log.isDebugEnabled) {
      const fields = {
        command: path.basename(command),
        code,
        pid: childProcess.pid
      };

      if (out.length > 0) {
        fields.out = out;
      }

      _log().log.debug(fields, "exited");
    }

    if (code === 0) {
      if (resolve != null) {
        resolve(out);
      }
    } else {
      function formatOut(text, title) {
        return text.length === 0 ? "" : `\n${title}:\n${text}`;
      }

      reject(new Error(`${command} exited with code ${code}${formatOut(out, "Output")}${formatOut(errorOut, "Error output")}`));
    }
  });
}

function use(value, task) {
  return value == null ? null : task(value);
}

function debug7zArgs(command) {
  const args = [command, "-bd"];

  if (debug7z.enabled) {
    args.push("-bb");
  }

  return args;
}

function isEmptyOrSpaces(s) {
  return s == null || s.trim().length === 0;
}

function isTokenCharValid(token) {
  return /^[\w\/=+-]+$/.test(token);
} // fpm bug - rpm build --description is not escaped, well... decided to replace quite to smart quote
// http://leancrew.com/all-this/2010/11/smart-quotes-in-javascript/


function smarten(s) {
  // opening singles
  s = s.replace(/(^|[-\u2014\s(\["])'/g, "$1\u2018"); // closing singles & apostrophes

  s = s.replace(/'/g, "\u2019"); // opening doubles

  s = s.replace(/(^|[-\u2014/\[(\u2018\s])"/g, "$1\u201c"); // closing doubles

  s = s.replace(/"/g, "\u201d");
  return s;
}

function addValue(map, key, value) {
  const list = map.get(key);

  if (list == null) {
    map.set(key, [value]);
  } else if (!list.includes(value)) {
    list.push(value);
  }
}

function replaceDefault(inList, defaultList) {
  if (inList == null || inList.length === 1 && inList[0] === "default") {
    return defaultList;
  }

  const index = inList.indexOf("default");

  if (index >= 0) {
    const list = inList.slice(0, index);
    list.push(...defaultList);

    if (index !== inList.length - 1) {
      list.push(...inList.slice(index + 1));
    }

    inList = list;
  }

  return inList;
}

function getPlatformIconFileName(value, isMac) {
  if (value === undefined) {
    return undefined;
  }

  if (value === null) {
    return null;
  }

  if (!value.includes(".")) {
    return `${value}.${isMac ? "icns" : "ico"}`;
  }

  return value.replace(isMac ? ".ico" : ".icns", isMac ? ".icns" : ".ico");
}

function isPullRequest() {
  // TRAVIS_PULL_REQUEST is set to the pull request number if the current job is a pull request build, or false if it’s not.
  function isSet(value) {
    // value can be or null, or empty string
    return value && value !== "false";
  }

  return isSet(process.env.TRAVIS_PULL_REQUEST) || isSet(process.env.CI_PULL_REQUEST) || isSet(process.env.CI_PULL_REQUESTS) || isSet(process.env.BITRISE_PULL_REQUEST) || isSet(process.env.APPVEYOR_PULL_REQUEST_NUMBER);
}

function isEnvTrue(value) {
  if (value != null) {
    value = value.trim();
  }

  return value === "true" || value === "" || value === "1";
}

class InvalidConfigurationError extends Error {
  constructor(message, code = "ERR_ELECTRON_BUILDER_INVALID_CONFIGURATION") {
    super(message);
    this.code = code;
  }

}

exports.InvalidConfigurationError = InvalidConfigurationError;

function executeAppBuilder(args) {
  return new Promise((resolve, reject) => {
    const command = _appBuilderBin().appBuilderPath;

    handleProcess("close", doSpawn(command, args, {
      env: Object.assign({}, process.env, {
        SZA_PATH: _zipBin().path7za
      }),
      stdio: ["ignore", "pipe", "inherit"]
    }), command, true, resolve, reject);
  });
} 
//# sourceMappingURL=util.js.map