package main

import (
	_ "net/http/pprof"

	"github.com/skycoin/skycoin/src/skycoin"
	"github.com/skycoin/skycoin/src/util/logging"
	"github.com/skycoin/skycoin/src/visor"
)

var (
	// Version of the node. Can be set by -ldflags
	Version = "0.24.1"
	// Commit ID. Can be set by -ldflags
	Commit = ""
	// Branch name. Can be set by -ldflags
	Branch = ""
	// ConfigMode (possible values are "", "STANDALONE_CLIENT").
	// This is used to change the default configuration.
	// Can be set by -ldflags
	ConfigMode = ""

	logger = logging.MustGetLogger("main")

	// GenesisSignatureStr hex string of genesis signature
	GenesisSignatureStr = "69f9de394a2dd336d522d5558b4032c0c20dd1de33566cfe157399dfc7fc2c3b4ebb1b70399fdd71733c9a4564b4f0c0535c16bf737339e1d4737aa4a650560e00"
	// GenesisAddressStr genesis address string
	GenesisAddressStr = "2eoXhtqtafcZaLCbXiL6ACJ1kRhrHWxquST"
	// BlockchainPubkeyStr pubic key string
	BlockchainPubkeyStr = "030a3dc28614128bc3abe364901784fd9e92c627dee0041d9518bafd651c6978bf"
	// BlockchainSeckeyStr empty private key string
	BlockchainSeckeyStr = ""

	// GenesisTimestamp genesis block create unix time
	GenesisTimestamp uint64 = 1619411071

	// GenesisCoinVolume represents the coin capacity
	GenesisCoinVolume uint64 = 100000000000000000

	// DefaultConnections the default trust node addresses
	DefaultConnections = []string{
		"104.129.183.104:8220",
		"104.129.183.125:8220",
		"104.129.181.176:8220",
	}
)

func main() {
	// get node config
	nodeConfig := skycoin.NewNodeConfig(ConfigMode, skycoin.NodeParameters{
		GenesisSignatureStr: GenesisSignatureStr,
		GenesisAddressStr:   GenesisAddressStr,
		GenesisCoinVolume:   GenesisCoinVolume,
		GenesisTimestamp:    GenesisTimestamp,
		BlockchainPubkeyStr: BlockchainPubkeyStr,
		BlockchainSeckeyStr: BlockchainSeckeyStr,
		DefaultConnections:  DefaultConnections,
		PeerListURL:         "",
		Port:                8220,
		WebInterfacePort:    8230,
		DataDirectory:       "$HOME/.aixexchange",
		ProfileCPUFile:      "aixexchange.prof",
	})

	// create a new fiber coin instance
	coin := skycoin.NewCoin(
		skycoin.Config{
			Node: *nodeConfig,
			Build: visor.BuildInfo{
				Version: Version,
				Commit:  Commit,
				Branch:  Branch,
			},
		},
		logger,
	)

	// parse config values
	coin.ParseConfig()

	// run fiber coin node
	coin.Run()
}
