"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.computeEnv = computeEnv;
exports.computeToolEnv = computeToolEnv;
exports.EXEC_TIMEOUT = void 0;
// 2 minutes
const EXEC_TIMEOUT = {
  timeout: 120 * 1000
};
exports.EXEC_TIMEOUT = EXEC_TIMEOUT;

function computeEnv(oldValue, newValues) {
  const parsedOldValue = oldValue ? oldValue.split(":") : [];
  return newValues.concat(parsedOldValue).filter(it => it.length > 0).join(":");
}

function computeToolEnv(libPath) {
  // noinspection SpellCheckingInspection
  return Object.assign({}, process.env, {
    DYLD_LIBRARY_PATH: computeEnv(process.env.DYLD_LIBRARY_PATH, libPath)
  });
} 
//# sourceMappingURL=bundledTool.js.map