"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.httpExecutor = exports.NodeHttpExecutor = void 0;

function _builderUtilRuntime() {
  const data = require("builder-util-runtime");

  _builderUtilRuntime = function () {
    return data;
  };

  return data;
}

function _binDownload() {
  const data = require("./binDownload");

  _binDownload = function () {
    return data;
  };

  return data;
}

function _http() {
  const data = require("http");

  _http = function () {
    return data;
  };

  return data;
}

function https() {
  const data = _interopRequireWildcard(require("https"));

  https = function () {
    return data;
  };

  return data;
}

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

class NodeHttpExecutor extends _builderUtilRuntime().HttpExecutor {
  // used only in tests of electron-updater
  download(url, destination, options) {
    return (0, _binDownload().download)(url, destination, options == null ? null : options.sha512).then(() => destination);
  } // noinspection JSMethodCanBeStatic
  // noinspection JSUnusedGlobalSymbols


  doRequest(options, callback) {
    return (options.protocol === "http:" ? _http().request : https().request)(options, callback);
  }

}

exports.NodeHttpExecutor = NodeHttpExecutor;
const httpExecutor = new NodeHttpExecutor(); exports.httpExecutor = httpExecutor;
//# sourceMappingURL=nodeHttpExecutor.js.map