"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.printErrorAndExit = printErrorAndExit;
exports.orNullIfFileNotExist = orNullIfFileNotExist;
exports.orIfFileNotExist = orIfFileNotExist;
exports.NestedError = exports.executeFinally = void 0;

function _bluebirdLst() {
  const data = require("bluebird-lst");

  _bluebirdLst = function () {
    return data;
  };

  return data;
}

function _chalk() {
  const data = _interopRequireDefault(require("chalk"));

  _chalk = function () {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function printErrorAndExit(error) {
  console.error(_chalk().default.red((error.stack || error).toString()));
  process.exit(1);
} // you don't need to handle error in your task - it is passed only indicate status of promise


let executeFinally = (() => {
  var _ref = (0, _bluebirdLst().coroutine)(function* (promise, task) {
    let result = null;

    try {
      result = yield promise;
    } catch (originalError) {
      try {
        yield task(true);
      } catch (taskError) {
        throw new NestedError([originalError, taskError]);
      }

      throw originalError;
    }

    try {
      yield task(false);
    } catch (taskError) {
      throw taskError;
    }

    return result;
  });

  return function executeFinally(_x, _x2) {
    return _ref.apply(this, arguments);
  };
})();

exports.executeFinally = executeFinally;

class NestedError extends Error {
  constructor(errors, message = "Compound error: ") {
    let m = message;
    let i = 1;

    for (const error of errors) {
      const prefix = `Error #${i++} `;
      m += "\n\n" + prefix + "-".repeat(80) + "\n" + error.stack;
    }

    super(m);
  }

}

exports.NestedError = NestedError;

function orNullIfFileNotExist(promise) {
  return orIfFileNotExist(promise, null);
}

function orIfFileNotExist(promise, fallbackValue) {
  return promise.catch(e => {
    if (e.code === "ENOENT" || e.code === "ENOTDIR") {
      return fallbackValue;
    }

    throw e;
  });
} 
//# sourceMappingURL=promise.js.map