import { Arch, AsyncTaskManager, DebugLogger } from "builder-util";
import { PackageBuilder } from "builder-util/out/api";
import { AppInfo } from "./appInfo";
import { CompressionLevel, Platform, Target, TargetSpecificOptions } from "./core";
import { AfterPackContext, Configuration, FileAssociation, PlatformSpecificBuildOptions } from "./index";
import { Packager } from "./packager";
import { PackagerOptions } from "./packagerApi";
export declare abstract class PlatformPackager<DC extends PlatformSpecificBuildOptions> implements PackageBuilder {
    readonly info: Packager;
    readonly platform: Platform;
    readonly packagerOptions: PackagerOptions;
    readonly buildResourcesDir: string;
    readonly projectDir: string;
    readonly config: Configuration;
    readonly platformSpecificBuildOptions: DC;
    readonly resourceList: Promise<Array<string>>;
    private readonly _resourceList;
    readonly appInfo: AppInfo;
    protected constructor(info: Packager, platform: Platform);
    readonly compression: CompressionLevel;
    readonly debugLogger: DebugLogger;
    readonly abstract defaultTarget: Array<string>;
    protected prepareAppInfo(appInfo: AppInfo): AppInfo;
    private static normalizePlatformSpecificBuildOptions(options);
    abstract createTargets(targets: Array<string>, mapper: (name: string, factory: (outDir: string) => Target) => void): void;
    protected getCscPassword(): string;
    protected getCscLink(extraEnvName?: string | null): string | null | undefined;
    protected doGetCscPassword(): string | null | undefined;
    protected computeAppOutDir(outDir: string, arch: Arch): string;
    dispatchArtifactCreated(file: string, target: Target | null, arch: Arch | null, safeArtifactName?: string | null): void;
    pack(outDir: string, arch: Arch, targets: Array<Target>, taskManager: AsyncTaskManager): Promise<any>;
    protected packageInDistributableFormat(appOutDir: string, arch: Arch, targets: Array<Target>, taskManager: AsyncTaskManager): void;
    private static buildAsyncTargets(targets, taskManager, appOutDir, arch);
    private getExtraFileMatchers(isResources, appOutDir, options);
    readonly electronDistExecutableName: string;
    readonly electronDistMacOsExecutableName: string;
    protected doPack(outDir: string, appOutDir: string, platformName: string, arch: Arch, platformSpecificBuildOptions: DC, targets: Array<Target>): Promise<void>;
    private copyAppFiles(taskManager, asarOptions, resourcePath, defaultDestination, outDir, platformSpecificBuildOptions, excludePatterns, macroExpander);
    protected signApp(packContext: AfterPackContext): Promise<any>;
    getIconPath(): Promise<string | null>;
    private computeAsarOptions(customBuildOptions);
    getElectronSrcDir(dist: string): string;
    getElectronDestinationDir(appOutDir: string): string;
    getResourcesDir(appOutDir: string): string;
    getMacOsResourcesDir(appOutDir: string): string;
    private checkFileInPackage(resourcesDir, file, messagePrefix, isAsar);
    private sanityCheckPackage(appOutDir, isAsar);
    computeSafeArtifactName(suggestedName: string | null, ext: string, arch?: Arch | null, skipArchIfX64?: boolean): string | null;
    expandArtifactNamePattern(targetSpecificOptions: TargetSpecificOptions | null | undefined, ext: string, arch?: Arch | null, defaultPattern?: string, skipArchIfX64?: boolean): string;
    private computeArtifactName(pattern, ext, arch);
    expandMacro(pattern: string, arch?: string | null, extra?: any, isProductNameSanitized?: boolean): string;
    generateName(ext: string | null, arch: Arch, deployment: boolean, classifier?: string | null): string;
    generateName2(ext: string | null, classifier: string | null | undefined, deployment: boolean): string;
    getTempFile(suffix: string): Promise<string>;
    readonly fileAssociations: Array<FileAssociation>;
    getResource(custom: string | null | undefined, ...names: Array<string>): Promise<string | null>;
    readonly forceCodeSigning: boolean;
    protected getOrConvertIcon(format: IconFormat): Promise<string | null>;
    resolveIcon(sources: Array<string>, outputFormat: IconFormat): Promise<Array<IconInfo>>;
}
export interface IconInfo {
    file: string;
    size: number;
}
export declare type IconFormat = "icns" | "ico" | "set";
export declare function isSafeGithubName(name: string): boolean;
export declare function normalizeExt(ext: string): string;
export declare function resolveFunction<T>(executor: T | string): T;
export declare function chooseNotNull(v1: string | null | undefined, v2: string | null | undefined): string | null | undefined;
