import { Arch } from "builder-util";
import { CancellationToken, PublishConfiguration } from "builder-util-runtime";
import { PublishContext, Publisher, PublishOptions } from "electron-publish";
import { MultiProgress } from "electron-publish/out/multiProgress";
import { PlatformSpecificBuildOptions } from "../index";
import { Packager } from "../packager";
import { PlatformPackager } from "../platformPackager";
export declare class PublishManager implements PublishContext {
    private readonly packager;
    private readonly publishOptions;
    readonly cancellationToken: CancellationToken;
    private readonly nameToPublisher;
    private readonly taskManager;
    private readonly isPublish;
    readonly progress: MultiProgress | null;
    private readonly updateFileWriteTask;
    constructor(packager: Packager, publishOptions: PublishOptions, cancellationToken?: CancellationToken);
    private scheduleUpload(publishConfig, event);
    private artifactCreated(event);
    private getOrCreatePublisher(publishConfig, platformPackager);
    cancelTasks(): void;
    awaitTasks(): Promise<void>;
}
export declare function getAppUpdatePublishConfiguration(packager: PlatformPackager<any>, arch: Arch, errorIfCannot: boolean): Promise<PublishConfiguration | null>;
export declare function getPublishConfigsForUpdateInfo(packager: PlatformPackager<any>, publishConfigs: Array<PublishConfiguration> | null, arch: Arch | null): Promise<Array<PublishConfiguration> | null>;
export declare function createPublisher(context: PublishContext, version: string, publishConfig: PublishConfiguration, options: PublishOptions): Publisher | null;
export declare function computeDownloadUrl(publishConfiguration: PublishConfiguration, fileName: string | null, packager: PlatformPackager<any>): string;
export declare function getPublishConfigs(packager: PlatformPackager<any>, targetSpecificOptions: PlatformSpecificBuildOptions | null | undefined, arch: Arch | null, errorIfCannot: boolean): Promise<Array<PublishConfiguration> | null>;
