"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _bluebirdLst() {
  const data = _interopRequireWildcard(require("bluebird-lst"));

  _bluebirdLst = function () {
    return data;
  };

  return data;
}

function _builderUtil() {
  const data = require("builder-util");

  _builderUtil = function () {
    return data;
  };

  return data;
}

function _builderUtilRuntime() {
  const data = require("builder-util-runtime");

  _builderUtilRuntime = function () {
    return data;
  };

  return data;
}

function _fs() {
  const data = require("builder-util/out/fs");

  _fs = function () {
    return data;
  };

  return data;
}

function ejs() {
  const data = _interopRequireWildcard(require("ejs"));

  ejs = function () {
    return data;
  };

  return data;
}

function _fsExtraP() {
  const data = require("fs-extra-p");

  _fsExtraP = function () {
    return data;
  };

  return data;
}

function _lazyVal() {
  const data = require("lazy-val");

  _lazyVal = function () {
    return data;
  };

  return data;
}

var path = _interopRequireWildcard(require("path"));

function _core() {
  const data = require("../core");

  _core = function () {
    return data;
  };

  return data;
}

function _PublishManager() {
  const data = require("../publish/PublishManager");

  _PublishManager = function () {
    return data;
  };

  return data;
}

function _pathManager() {
  const data = require("../util/pathManager");

  _pathManager = function () {
    return data;
  };

  return data;
}

function _targetUtil() {
  const data = require("./targetUtil");

  _targetUtil = function () {
    return data;
  };

  return data;
}

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

const appRunTemplate = new (_lazyVal().Lazy)((0, _bluebirdLst().coroutine)(function* () {
  return ejs().compile((yield (0, _fsExtraP().readFile)(path.join((0, _pathManager().getTemplatePath)("linux"), "AppRun.sh"), "utf-8")));
})); // https://unix.stackexchange.com/questions/375191/append-to-sub-directory-inside-squashfs-file

class AppImageTarget extends _core().Target {
  constructor(ignored, packager, helper, outDir) {
    super("appImage");
    this.packager = packager;
    this.helper = helper;
    this.outDir = outDir;
    this.options = Object.assign({}, this.packager.platformSpecificBuildOptions, this.packager.config[this.name]); // we add X-AppImage-BuildId to ensure that new desktop file will be installed

    this.desktopEntry = new (_lazyVal().Lazy)(() => helper.computeDesktopEntry(this.options, "AppRun", {
      "X-AppImage-Version": `${packager.appInfo.buildVersion}`,
      "X-AppImage-BuildId": _builderUtilRuntime().UUID.v1()
    }));
  }

  build(appOutDir, arch) {
    var _this = this;

    return (0, _bluebirdLst().coroutine)(function* () {
      const packager = _this.packager; // https://github.com/electron-userland/electron-builder/issues/775
      // https://github.com/electron-userland/electron-builder/issues/1726
      // tslint:disable-next-line:no-invalid-template-strings

      const artifactName = packager.expandArtifactNamePattern(_this.options, "AppImage", arch, "${name}-${version}-${arch}.${ext}", false);
      const artifactPath = path.join(_this.outDir, artifactName);

      _this.logBuilding("AppImage", artifactPath, arch);

      const stageDir = yield (0, _targetUtil().createStageDir)(_this, packager, arch);
      const resourceName = `appimagekit-${_this.packager.executableName}`;
      const installIcons = yield _this.copyIcons(stageDir.dir, resourceName);
      const finalDesktopFilename = `${_this.packager.executableName}.desktop`;
      yield Promise.all([(0, _fs().unlinkIfExists)(artifactPath), (0, _fsExtraP().writeFile)(stageDir.getTempFile("/AppRun"), (yield appRunTemplate.value)({
        systemIntegration: _this.options.systemIntegration || "ask",
        desktopFileName: finalDesktopFilename,
        executableName: _this.packager.executableName,
        resourceName,
        installIcons
      }), {
        mode: "0755"
      }), (0, _fsExtraP().writeFile)(stageDir.getTempFile(finalDesktopFilename), (yield _this.desktopEntry.value))]); // must be after this.helper.icons call

      if (_this.helper.maxIconPath == null) {
        throw new Error("Icon is not provided");
      }

      if (_this.packager.packagerOptions.effectiveOptionComputed != null && (yield _this.packager.packagerOptions.effectiveOptionComputed({
        desktop: yield _this.desktopEntry.value
      }))) {
        return;
      }

      const publishConfig = yield (0, _PublishManager().getAppUpdatePublishConfiguration)(packager, arch, false
      /* in any case validation will be done on publish */
      );

      if (publishConfig != null) {
        yield (0, _fsExtraP().outputFile)(path.join(packager.getResourcesDir(stageDir.getTempFile("app")), "app-update.yml"), (0, _builderUtil().serializeToYaml)(publishConfig));
      }

      const args = ["appimage", "--stage", stageDir.dir, "--arch", _builderUtil().Arch[arch], "--output", artifactPath, "--app", appOutDir];

      if (packager.compression === "maximum") {
        args.push("--compression", "xz");
      }

      packager.info.dispatchArtifactCreated({
        file: artifactPath,
        safeArtifactName: packager.computeSafeArtifactName(artifactName, "AppImage", arch, false),
        target: _this,
        arch,
        packager,
        isWriteUpdateInfo: true,
        updateInfo: JSON.parse((yield (0, _builderUtil().executeAppBuilder)(args)))
      });
    })();
  }

  copyIcons(stageDir, resourceName) {
    var _this2 = this;

    return (0, _bluebirdLst().coroutine)(function* () {
      const iconDirRelativePath = "usr/share/icons/hicolor";
      const iconDir = path.join(stageDir, iconDirRelativePath);
      yield (0, _fsExtraP().ensureDir)(iconDir); // https://github.com/AppImage/AppImageKit/issues/438#issuecomment-319094239
      // expects icons in the /usr/share/icons/hicolor

      const iconNames = yield _bluebirdLst().default.map(_this2.helper.icons, (() => {
        var _ref2 = (0, _bluebirdLst().coroutine)(function* (icon) {
          const filename = `${_this2.packager.executableName}.png`;
          const iconSizeDir = `${icon.size}x${icon.size}/apps`;
          const dir = path.join(iconDir, iconSizeDir);
          yield (0, _fsExtraP().ensureDir)(dir);
          const finalIconFile = path.join(dir, filename);
          yield (0, _fs().copyOrLinkFile)(icon.file, finalIconFile, null, true);

          if (icon.file === _this2.helper.maxIconPath) {
            yield (0, _fsExtraP().symlink)(path.relative(stageDir, finalIconFile), path.join(stageDir, filename));
          }

          return {
            filename,
            iconSizeDir,
            size: icon.size
          };
        });

        return function (_x) {
          return _ref2.apply(this, arguments);
        };
      })());
      let installIcons = "";

      for (const icon of iconNames) {
        installIcons += `xdg-icon-resource install --noupdate --context apps --size ${icon.size} "$APPDIR/${iconDirRelativePath}/${icon.iconSizeDir}/${icon.filename}" "${resourceName}"\n`;
      }

      return installIcons;
    })();
  }

} exports.default = AppImageTarget;
//# sourceMappingURL=AppImageTarget.js.map