"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinuxTargetHelper = exports.installPrefix = void 0;

function _bluebirdLst() {
  const data = require("bluebird-lst");

  _bluebirdLst = function () {
    return data;
  };

  return data;
}

function _builderUtil() {
  const data = require("builder-util");

  _builderUtil = function () {
    return data;
  };

  return data;
}

function _fsExtraP() {
  const data = require("fs-extra-p");

  _fsExtraP = function () {
    return data;
  };

  return data;
}

function _lazyVal() {
  const data = require("lazy-val");

  _lazyVal = function () {
    return data;
  };

  return data;
}

var path = _interopRequireWildcard(require("path"));

function _pathManager() {
  const data = require("../util/pathManager");

  _pathManager = function () {
    return data;
  };

  return data;
}

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

const installPrefix = "/opt";
exports.installPrefix = installPrefix;

class LinuxTargetHelper {
  constructor(packager) {
    this.packager = packager;
    this.iconPromise = new (_lazyVal().Lazy)(() => this.computeDesktopIcons());
    this.maxIconPath = null;
  }

  get icons() {
    return this.iconPromise.value;
  } // must be name without spaces and other special characters, but not product name used


  computeDesktopIcons() {
    var _this = this;

    return (0, _bluebirdLst().coroutine)(function* () {
      const packager = _this.packager;
      const iconDir = packager.platformSpecificBuildOptions.icon;
      const sources = [iconDir == null ? "icons" : iconDir];
      const commonConfiguration = packager.config;
      let icnsPath = (commonConfiguration.mac || {}).icon || commonConfiguration.icon;

      if (icnsPath != null) {
        if (!icnsPath.endsWith(".icns")) {
          icnsPath += ".icns";
        }

        sources.push(icnsPath);
      }

      sources.push("icon.icns");
      sources.push(path.join((0, _pathManager().getTemplatePath)("linux"), "electron-icons"));
      const result = yield packager.resolveIcon(sources, "set");
      _this.maxIconPath = result[result.length - 1].file;
      return result;
    })();
  }

  getDescription(options) {
    return options.description || this.packager.appInfo.description;
  }

  writeDesktopEntry(targetSpecificOptions, exec, destination, extra) {
    var _this2 = this;

    return (0, _bluebirdLst().coroutine)(function* () {
      const data = yield _this2.computeDesktopEntry(targetSpecificOptions, exec, extra);
      const file = destination || (yield _this2.packager.getTempFile(`${_this2.packager.appInfo.productFilename}.desktop`));
      yield (0, _fsExtraP().outputFile)(file, data);
      return file;
    })();
  }

  computeDesktopEntry(targetSpecificOptions, exec, extra) {
    var _this3 = this;

    return (0, _bluebirdLst().coroutine)(function* () {
      if (exec != null && exec.length === 0) {
        throw new Error("Specified exec is empty");
      }

      const appInfo = _this3.packager.appInfo;
      const productFilename = appInfo.productFilename;
      const desktopMeta = Object.assign({
        Name: appInfo.productName,
        Comment: _this3.getDescription(targetSpecificOptions),
        Exec: exec == null ? `"${installPrefix}/${productFilename}/${_this3.packager.executableName}" %U` : exec,
        Terminal: "false",
        Type: "Application",
        Icon: _this3.packager.executableName
      }, extra, targetSpecificOptions.desktop);
      let category = targetSpecificOptions.category;

      if ((0, _builderUtil().isEmptyOrSpaces)(category)) {
        const macCategory = (_this3.packager.config.mac || {}).category;

        if (macCategory != null) {
          category = macToLinuxCategory[macCategory];
        }

        if (category == null) {
          // https://github.com/develar/onshape-desktop-shell/issues/48
          if (macCategory != null) {
            _builderUtil().log.warn({
              macCategory
            }, "cannot map macOS category to Linux. If possible mapping is known for you, please file issue to add it.");
          }

          _builderUtil().log.warn({
            reason: "linux.category is not set and cannot map from macOS",
            docs: "https://electron.build/configuration/configuration#LinuxBuildOptions-category"
          }, "application Linux category is set to default \"Utility\"");

          category = "Utility";
        }
      }

      desktopMeta.Categories = `${category}${category.endsWith(";") ? "" : ";"}`;
      let data = `[Desktop Entry]`;

      for (const name of Object.keys(desktopMeta)) {
        const value = desktopMeta[name];
        data += `\n${name}=${value}`;
      }

      data += "\n";
      return data;
    })();
  }

}

exports.LinuxTargetHelper = LinuxTargetHelper;
const macToLinuxCategory = {
  "public.app-category.graphics-design": "Graphics",
  "public.app-category.developer-tools": "Development",
  "public.app-category.education": "Education",
  "public.app-category.games": "Game",
  "public.app-category.video": "Video;AudioVideo",
  "public.app-category.utilities": "Utility",
  "public.app-category.social-networking": "Chat",
  "public.app-category.finance": "Finance"
}; 
//# sourceMappingURL=LinuxTargetHelper.js.map