"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compute7zCompressArgs = compute7zCompressArgs;
exports.archive = exports.tar = void 0;

function _bluebirdLst() {
  const data = require("bluebird-lst");

  _bluebirdLst = function () {
    return data;
  };

  return data;
}

function _zipBin() {
  const data = require("7zip-bin");

  _zipBin = function () {
    return data;
  };

  return data;
}

function _builderUtil() {
  const data = require("builder-util");

  _builderUtil = function () {
    return data;
  };

  return data;
}

function _fs() {
  const data = require("builder-util/out/fs");

  _fs = function () {
    return data;
  };

  return data;
}

function _fsExtraP() {
  const data = require("fs-extra-p");

  _fsExtraP = function () {
    return data;
  };

  return data;
}

var path = _interopRequireWildcard(require("path"));

function _tools() {
  const data = require("./tools");

  _tools = function () {
    return data;
  };

  return data;
}

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

/** @internal */
let tar = (() => {
  var _ref = (0, _bluebirdLst().coroutine)(function* (compression, format, outFile, dirToArchive, isMacApp, tempDirManager) {
    const tarFile = yield tempDirManager.getTempFile({
      suffix: ".tar"
    });
    const tarArgs = (0, _builderUtil().debug7zArgs)("a");
    tarArgs.push(tarFile);
    tarArgs.push(path.basename(dirToArchive));
    yield Promise.all([(0, _builderUtil().exec)(_zipBin().path7za, tarArgs, {
      cwd: path.dirname(dirToArchive)
    }), // remove file before - 7z doesn't overwrite file, but update
    (0, _fs().unlinkIfExists)(outFile)]);

    if (!isMacApp) {
      yield (0, _builderUtil().exec)(_zipBin().path7za, ["rn", tarFile, path.basename(dirToArchive), path.basename(outFile, `.${format}`)]);
    }

    if (format === "tar.lz") {
      // noinspection SpellCheckingInspection
      let lzipPath = "lzip";

      if (process.platform === "darwin") {
        lzipPath = path.join((yield (0, _tools().getLinuxToolsPath)()), "bin", lzipPath);
      }

      yield (0, _builderUtil().exec)(lzipPath, [compression === "store" ? "-1" : "-9", "--keep"
      /* keep (don't delete) input files */
      , tarFile]); // bloody lzip creates file in the same dir where input file with postfix `.lz`, option --output doesn't work

      yield (0, _fsExtraP().move)(`${tarFile}.lz`, outFile);
      return;
    }

    const args = compute7zCompressArgs(format === "tar.xz" ? "xz" : format === "tar.bz2" ? "bzip2" : "gzip", {
      isRegularFile: true,
      method: "DEFAULT",
      compression
    });
    args.push(outFile, tarFile);
    yield (0, _builderUtil().exec)(_zipBin().path7za, args, {
      cwd: path.dirname(dirToArchive)
    }, _builderUtil().debug7z.enabled);
  });

  return function tar(_x, _x2, _x3, _x4, _x5, _x6) {
    return _ref.apply(this, arguments);
  };
})();

exports.tar = tar;

function compute7zCompressArgs(format, options = {}) {
  let storeOnly = options.compression === "store";
  const args = (0, _builderUtil().debug7zArgs)("a");
  let isLevelSet = false;

  if (process.env.ELECTRON_BUILDER_COMPRESSION_LEVEL != null) {
    storeOnly = false;
    args.push(`-mx=${process.env.ELECTRON_BUILDER_COMPRESSION_LEVEL}`);
    isLevelSet = true;
  }

  if (format === "zip" && options.compression === "maximum") {
    // http://superuser.com/a/742034
    args.push("-mfb=258", "-mpass=15");
  }

  if (!isLevelSet && !storeOnly) {
    args.push("-mx=9");
  }

  if (options.dictSize != null) {
    args.push(`-md=${options.dictSize}m`);
  } // https://sevenzip.osdn.jp/chm/cmdline/switches/method.htm#7Z
  // https://stackoverflow.com/questions/27136783/7zip-produces-different-output-from-identical-input
  // tc and ta are off by default, but to be sure, we explicitly set it to off
  // disable "Stores NTFS timestamps for files: Modification time, Creation time, Last access time." to produce the same archive for the same data


  if (!options.isRegularFile) {
    args.push("-mtc=off");
  }

  if (format === "7z" || format.endsWith(".7z")) {
    if (options.solid === false) {
      args.push("-ms=off");
    }

    if (options.isArchiveHeaderCompressed === false) {
      args.push("-mhc=off");
    } // args valid only for 7z
    // -mtm=off disable "Stores last Modified timestamps for files."


    args.push("-mtm=off", "-mta=off");
  }

  if (options.method != null) {
    if (options.method !== "DEFAULT") {
      args.push(`-mm=${options.method}`);
    }
  } else if (format === "zip" || storeOnly) {
    args.push(`-mm=${storeOnly ? "Copy" : "Deflate"}`);
  }

  if (format === "zip") {
    // -mcu switch:  7-Zip uses UTF-8, if there are non-ASCII symbols.
    // because default mode: 7-Zip uses UTF-8, if the local code page doesn't contain required symbols.
    // but archive should be the same regardless where produced
    args.push("-mcu");
  }

  return args;
} // 7z is very fast, so, use ultra compression

/** @internal */


let archive = (() => {
  var _ref2 = (0, _bluebirdLst().coroutine)(function* (format, outFile, dirToArchive, options = {}) {
    const args = compute7zCompressArgs(format, options); // remove file before - 7z doesn't overwrite file, but update

    yield (0, _fs().unlinkIfExists)(outFile);
    args.push(outFile, options.listFile == null ? options.withoutDir ? "." : path.basename(dirToArchive) : `@${options.listFile}`);

    if (options.excluded != null) {
      for (const mask of options.excluded) {
        args.push(`-xr!${mask}`);
      }
    }

    try {
      yield (0, _builderUtil().exec)(_zipBin().path7za, args, {
        cwd: options.withoutDir ? dirToArchive : path.dirname(dirToArchive)
      }, _builderUtil().debug7z.enabled);
    } catch (e) {
      if (e.code === "ENOENT" && !(yield (0, _fs().exists)(dirToArchive))) {
        throw new Error(`Cannot create archive: "${dirToArchive}" doesn't exist`);
      } else {
        throw e;
      }
    }

    return outFile;
  });

  return function archive(_x7, _x8, _x9) {
    return _ref2.apply(this, arguments);
  };
})(); exports.archive = archive;
//# sourceMappingURL=archive.js.map