"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLinuxToolsPath = getLinuxToolsPath;
exports.prefetchBuildTools = prefetchBuildTools;
exports.getZstd = getZstd;
exports.getAria = getAria;
exports.getTool = getTool;
exports.fpmPath = void 0;

function _binDownload() {
  const data = require("builder-util/out/binDownload");

  _binDownload = function () {
    return data;
  };

  return data;
}

function _lazyVal() {
  const data = require("lazy-val");

  _lazyVal = function () {
    return data;
  };

  return data;
}

var path = _interopRequireWildcard(require("path"));

function _core() {
  const data = require("../core");

  _core = function () {
    return data;
  };

  return data;
}

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function getLinuxToolsPath() {
  //noinspection SpellCheckingInspection
  return (0, _binDownload().getBinFromGithub)("linux-tools", "mac-10.12.3", "SQ8fqIRVXuQVWnVgaMTDWyf2TLAJjJYw3tRSqQJECmgF6qdM7Kogfa6KD49RbGzzMYIFca9Uw3MdsxzOPRWcYw==");
}

const fpmPath = new (_lazyVal().Lazy)(() => {
  if (process.platform === "win32" || process.env.USE_SYSTEM_FPM === "true") {
    return Promise.resolve("fpm");
  }

  const osAndArch = process.platform === "darwin" ? "mac" : `linux-x86${process.arch === "ia32" ? "" : "_64"}`;

  if (process.platform === "darwin") {
    //noinspection SpellCheckingInspection
    return (0, _binDownload().getBinFromGithub)("fpm", "1.9.3-20150715-2.2.2-mac", "oXfq+0H2SbdrbMik07mYloAZ8uHrmf6IJk+Q3P1kwywuZnKTXSaaeZUJNlWoVpRDWNu537YxxpBQWuTcF+6xfw==").then(it => path.join(it, "fpm"));
  } //noinspection SpellCheckingInspection


  const checksum = process.arch === "ia32" ? "OnzvBdsHE5djcXcAT87rwbnZwS789ZAd2ehuIO42JWtBAHNzXKxV4o/24XFX5No4DJWGO2YSGQttW+zn7d/4rQ==" : "fcKdXPJSso3xFs5JyIJHG1TfHIRTGDP0xhSBGZl7pPZlz4/TJ4rD/q3wtO/uaBBYeX0qFFQAFjgu1uJ6HLHghA==";
  return (0, _binDownload().getBinFromGithub)("fpm", `1.9.3-2.3.1-${osAndArch}`, checksum).then(it => path.join(it, "fpm"));
}); // noinspection JSUnusedGlobalSymbols

exports.fpmPath = fpmPath;

function prefetchBuildTools() {
  // yes, we starting to use native Promise
  return fpmPath.value;
}

function getZstd() {
  // noinspection SpellCheckingInspection
  return getTool({
    name: "zstd",
    version: "1.3.3",
    mac: "RnFYU+gEieQFCu943WEmh++PT5TZjDSqSCZvZj7ArfVkc+JS+DdGi30/466gqx9VFKsk6XpYrCpZNryFSvDOuw==",
    "linux-x64": "M1YpBtWX9C99hwRHF8bOLdN5bUFChMwWRc/NzGSwG48VVtegEV2RCFqbT1v0ZcSLC54muhOtK1VgMEmTKr0ouQ==",
    "win-ia32": "uUG8l+JQZtgFOq5G9lg3ryABiFA2gv14inJTAmpprywmbVfCVe++ikzJcjg5ZdLKhYDcB3nIsKE5c7pWY7+1yA==",
    "win-x64": "lBCx8nuRkEu8oQqgXosuO9e35BQOSyugFaK5ExBiTKh6qkv6amsYEUNELZGmEqH+FXscagxq+7+QUYkWJfmROQ=="
  });
}

function getAria() {
  const platform = _core().Platform.current();

  const archQualifier = platform === _core().Platform.MAC ? "" : `-${process.arch}`;
  let checksum = "";

  if (platform === _core().Platform.MAC) {
    // noinspection SpellCheckingInspection
    checksum = "UjstpQUAtoP/sZ9SNuWwIN1WyDfvr1V3bzLGzTZCt1IqQsf9YwBSo0jrXMMRZOqv1sy5EOvp5nyC4VvJZCRVuQ==";
  } else if (platform === _core().Platform.WINDOWS) {
    // noinspection SpellCheckingInspection
    checksum = process.arch === "ia32" ? "aulZig14OCHqj5qUWDvIAacibzW9k+gfDGDeECzWDrF7FPYzI+Vn7Q7QnW/FXNyNnbe8PeYawTlGzD3vJxLQWg==" : "zksKH0Uazwtc/vfGSVy+tzsNou+thSamAGTKt8P1DLoNkdSz9ueaIFoJ7jt8jlDds8Z6Rrxls6IFkZRBDxiyfg==";
  } //noinspection SpellCheckingInspection


  return (0, _binDownload().getBinFromGithub)(`aria2-${platform.buildConfigurationKey}${archQualifier}`, "1.33.1", checksum).then(it => path.join(it, `aria2c${platform === _core().Platform.WINDOWS ? ".exe" : ""}`));
}

function getTool(descriptor) {
  let arch = process.arch;

  if (arch === "arm") {
    arch = "armv7";
  } else if (arch === "arm64") {
    arch = "armv8";
  }

  const platform = _core().Platform.current();

  const checksum = platform === _core().Platform.MAC ? descriptor.mac : descriptor[`${platform.buildConfigurationKey}-${arch}`];

  if (checksum == null) {
    throw new Error(`Checksum not specified for ${platform}:${arch}`);
  }

  const archQualifier = platform === _core().Platform.MAC ? "" : `-${arch}`; // https://github.com/develar/block-map-builder/releases/download/v0.0.1/block-map-builder-v0.0.1-win-x64.7z

  const version = descriptor.version;
  const name = descriptor.name;
  const repository = descriptor.repository || "electron-userland/electron-builder-binaries";
  const tagPrefix = descriptor.repository == null ? `${name}-` : "v";
  return (0, _binDownload().getBin)(`${name}-${version}-${process.arch}`, `https://github.com/${repository}/releases/download/${tagPrefix}${version}/${name}-v${version}-${platform.buildConfigurationKey}${archQualifier}.7z`, checksum).then(it => path.join(it, `${name}${platform === _core().Platform.WINDOWS ? ".exe" : ""}`));
} 
//# sourceMappingURL=tools.js.map