"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonStreamParser = void 0;
var ReadState;

(function (ReadState) {
  ReadState[ReadState["HEADER"] = 0] = "HEADER";
  ReadState[ReadState["BODY"] = 1] = "BODY";
})(ReadState || (ReadState = {}));

class JsonStreamParser {
  constructor(eventHandler) {
    this.eventHandler = eventHandler;
    this.state = ReadState.HEADER;
    this.buffer = "";
    this.remainingMessageLength = 0;
  } // https://github.com/EventSource/eventsource/blob/master/lib/eventsource.js


  parseIncoming(chunk) {
    let offset = 0;

    while (offset < chunk.length) {
      if (this.state === ReadState.HEADER) {
        if (chunk.length === 1 && chunk[0] === " ") {
          // ping
          return;
        }

        for (let i = offset; i < chunk.length; i++) {
          if (chunk[i] === "{") {
            this.buffer += chunk.substring(0, i);
            this.remainingMessageLength = parseInt(this.buffer.trim(), 10);
            this.buffer = "";
            offset = i;
            this.state = ReadState.BODY;
            break;
          }
        }
      }

      const end = offset + this.remainingMessageLength;
      this.buffer += chunk.substring(offset, Math.min(chunk.length, end));
      this.remainingMessageLength -= chunk.length - offset;

      if (this.remainingMessageLength > 0) {
        return;
      }

      offset = end;
      this.remainingMessageLength = 0;
      this.state = ReadState.HEADER;
      const data = JSON.parse(this.buffer);
      this.buffer = "";
      this.eventHandler(data);
    }
  }

} exports.JsonStreamParser = JsonStreamParser;
//# sourceMappingURL=JsonStreamParser.js.map